<?php

namespace Modules\Tax\Sales;

use Illuminate\Database\Eloquent\Model;

class OrderType extends Model 
{

    protected $table = 'order_types';
    public $timestamps = true;

    public function order_nature_id()
    {
        return $this->belongsTo('OrderNature');
    }

    public function contact_type()
    {
        return $this->belongsTo('ContactType');
    }

    public function fiscal_document_type()
    {
        return $this->belongsTo('FiscalDocumentType');
    }

    public function default_invoice_type()
    {
        return $this->belongsTo('InvoiceType', 'default_invoice_type_id', 'id');
    }

    public function default_memo_type()
    {
        return $this->belongsTo('MemoType', 'default_memo_type_id', 'id');
    }

    public function document_type_issuing_services()
    {
        return $this->morphMany('DocumentTypeIssuingService', 'serviceable');
    }

    public function document_type_series()
    {
        return $this->morphMany('DocumentTypeSerie', 'serieable');
    }

}